import java.sql.SQLException;
import java.time.LocalDate;

public class Main {
    public static void main(String[] args) {
        // Initialize order data
        var customerId = 1;
        var bookId = 2;
        var orderQty = 3;
        var bookPrice = 29.99;
        var orderDate = LocalDate.of(2024, 7, 27);

        // Connect to the SQL Server
        try (var connection = SQLServerConnection.connect()) {
            var orderDB = new OrderDB(connection);
            // Create a new order
            var orderId = orderDB.createOrder(customerId, bookId, orderQty, bookPrice, orderDate);

            System.out.println("A sales order was created with the id: " + orderId);

        } catch (SQLException | DBException e) {
            System.err.println(e.getMessage());
        }
    }
}